jQuery(document).ready(function($){
	// Uploading files
	var file_frame = [];
	$('.remove_image_button').on('click', function( event ){
		event.preventDefault();
		var upload_id = $( this ).data( 'upload_id' );
		var upload_url = $( this ).data( 'upload_url' );
		//alert(upload_id + upload_url);
		$( '#' + upload_id ).attr('value',"");
		$( '#' + upload_url ).html("");
	});

	$('.upload_image_button').on('click', function( event ){
		event.preventDefault();
		var upload_id = $( this ).data( 'upload_id' );
		var upload_url = $( this ).data( 'upload_url' );
		// If the media frame already exists, reopen it.
		if ( typeof file_frame[upload_id] != 'undefined' ) {
			file_frame[upload_id].open();
			return;
		}
		// Create the media frame.
		file_frame[upload_id] = wp.media.frames.file_frame = wp.media({
			title: $( this ).data( 'uploader_title' ),
			button: {
				text: $( this ).data( 'uploader_button_text' ),
			},
			multiple: false	// Set to true to allow multiple files to be selected
		});
		file_frame[upload_id].on('open',function() {
			var selection = file_frame[upload_id].state().get('selection');
			var id = $( '#' + upload_id ).val();
			attachment = wp.media.attachment(id);
			attachment.fetch();
			selection.add( attachment ? [ attachment ] : [] );
		});

		// When an image is selected, run a callback.
		file_frame[upload_id].on( 'select', function() {
			// We set multiple to false so only get one image from the uploader
			attachment = file_frame[upload_id].state().get('selection').first().toJSON();

			// Do something with attachment.id and/or attachment.url here
			$( '#' + upload_id ).val( attachment.id );
			$( '#' + upload_url ).html( '<img src="' + attachment.sizes.thumbnail.url + '" />' );
		});
		// Finally, open the modal
		file_frame[upload_id].open();
	});
});