<?php
if(!class_exists('MU_Services')) {
	class MU_Services {
		public function __construct() {
			$this->registerPostType();
			
			add_action('admin_enqueue_scripts', array($this, 'admin_scripts'));
			add_action('save_post', array($this, 'save_service'));
		}
		
		public function save_service() {
			global $post;
			if(isset($_POST["bg_color"])) {
				update_post_meta($post->ID, 'bg_color', $_POST["bg_color"]);
			}
		}
		
		public function admin_scripts() {
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker' );
		}
		
		public function registerPostType() {
			register_post_type('services', array(
				'label'						=>	'Services',
				'labels'					=>	array(
					'name'					=>	'Services',
					'singular_name'			=>	'Service',
					'menu_name'				=>	'Services',
					'name_admin_bar'		=>	'Service',
					'all_items'				=>	'Services',
					'add_new_item'			=>	'New Service',
					'edit_item'				=>	'Edit Service',
					'new_item'				=>	'New Service',
					'view_item'				=>	'View Service',
					'search_items'			=>	'Search Services',
					'not_found'				=>	'No Services Found',
					'parent_item_colon'		=>	'Parent Service'
				),
				'description'				=>	'Custom services post type.',
				'public'					=>	true,
				'show_ui'					=>	true,
				'menu_position'				=>	20,
				'menu_icon'					=>	'dashicons-hammer',
				'capability_type'			=>	'page',
				'supports'					=>	array('title','editor','page-attributes'),
				'register_meta_box_cb'		=>	array($this, 'register_metaboxes'),
				'rewrite'					=>	false,
				'has_archive'				=>	false,
				'publicly_queryable'		=>	false,
				'exclude_from_search'		=>	true
			));
			
			register_taxonomy('service_cat', 'services', array(
				'label'						=>	'Categories',
				'labels'					=>	array(
					'name'					=>	'Categories',
					'singular_name'			=>	'Category',
					'menu_name'				=>	'Categories',
					'all_items'				=>	'All Categories',
					'edit_item'				=>	'Edit Category',
					'view_item'				=>	'View Category',
					'update_item'			=>	'Update Category',
					'add_new_item'			=>	'Add New Category',
					'new_item_name'			=>	'New Category Name',
					'parent_item'			=>	'Parent Category'
				)
			));
		}
		
		public function color_picker_mb() {
			global $post;
			?>
			<script>
			jQuery(function($) {
				$('.color-picker').wpColorPicker();
			});
			</script>
			<input type="text" class="widefat color-picker" name="bg_color" value="<?php echo get_post_meta($post->ID, 'bg_color', 1); ?>">
			<?php
		}
		
		public function register_metaboxes($post) {
			add_meta_box('color_picker', 'Background Color', array($this, 'color_picker_mb'), '', 'side', 'default');
		}
	}
	
	return new MU_Services();
}
?>