<?php
/*

	Layout specific functions, actions and filters
*/

/*
	@Name: 		add_home_page_slider
	@Purpose: 	add a the slider template part to just the front page.
	@Params: 	none
	@Returns: 	void (html to screen via `get_template_part` see `slider.php`)
	@hooked:	before_main_wrap
*/
function add_home_page_slider() {
	global $post;
	if(is_front_page()){
		get_template_part('slider-carousel');
	}
	else {
		$isblog = false;
		//featured image for page
		if(is_home() || is_single() || is_archive()) {
			$featured = wp_get_attachment_image_src( get_post_thumbnail_id(get_option('page_for_posts')) , 'full');
			$isblog = true;
		}
		else {
			$featured = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID) , 'full');
		}
		?>
		<div class="featured-container">
			<div class="featured-img" style="background-image: url(<?php echo $featured[0]; ?>);"></div>
			<?php echo apply_filters('hero_title', get_post_meta($isblog ? get_option('page_for_posts') : $post->ID, 'mu_hero_title', 1)); ?>
		</div>
		<?php
	}
}
add_action( 'after_header', 'add_home_page_slider' );


function do_staff_loop() {
	
			global $post;
			
			$details = get_staff_details( $post->ID );
			
			if(function_exists('has_post_thumbnail') && has_post_thumbnail()){
				$img = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large' );
			}
		?>
		<div class="col-sm-3 col-xs-6" style="position: relative;">
			<a href="#" class="staff-item-click" data-staff="<?php the_ID(); ?>">
				<div class="staff-item-wrap">
					<div class="staff-overlay"></div>
					<div class="staff-meta">
							<?php
								the_title('<div class="staff-name">','</div>', 1);
								the_staff_title('<div class="staff-title">', '</div>', 1);
							?>
						</div>
					<div class="staff-img" style="background-image:url(<?php echo $img[0]; ?>);"></div>
				</div>
			</a>
		</div>
		<?php
}
add_action('staff_loop_template_about_page', 'do_staff_loop', 10, 1);

/**
 * add page sidebar
 *
 *
 *
 * @return VOID
 */
function page_sidebar(){
	get_sidebar('page');
}
add_action('page_sidebar', 'page_sidebar', 10, 1 );

/**
 * add post sidebar
 *
 *
 *
 * @return VOID
 */
function post_sidebar(){
	get_sidebar('post');
}
add_action('after_blog_loop', 'post_sidebar', 10, 1 );
add_action('after_search_loop', 'post_sidebar', 10, 1 );
add_action('post_after_content', 'post_sidebar', 10, 1 );

/*
	@Name: 		mindutopia_posts_nav
	@Purpose: 	blog roll post nav older newer.
*/
function mindutopia_posts_nav(){
	get_template_part( 'partials/post/nav' );
}

add_action('blog_nav', 'mindutopia_posts_nav');

/*
	@Name: 		mindutopia_single_post_nav
	@Purpose: 	single post nav older newer.
*/
function mindutopia_single_post_nav(){
	get_template_part( 'partials/post/nav', 'single' );
}

add_action('post_nav', 'mindutopia_single_post_nav');

function mu_next_prev_item($in_same_term = false, $tax_name = 'category'){
	global $post;
	$prev_post = get_adjacent_post( $in_same_term , '' , true , $tax_name);
	$next_post = get_adjacent_post( $in_same_term , '' , false , $tax_name);
?>
<div id="posts-dir-nav">
	<ul class="pager">
		<?php
		if( empty( $prev_post ) || $prev_post->ID == get_the_ID() ){
			?>

			<li class="previous disabled"><a href="#"><i class="fa fa-chevron-left"></i> Back</a></li>
			<?php
		}
		else{ ?>

			<li class="previous"><a href="<?php echo get_the_permalink($prev_post->ID); ?>"><i class="fa fa-chevron-left"></i> Back</a></li>
			<?php
		}

		if( empty( $next_post ) || $next_post->ID == get_the_ID() ){ ?>
			<li class="next disabled"><a href="#">Next <i class="fa fa-chevron-right"></i></a>
			<?php
		}
		else{ ?>
			<li class="next"><a href="<?php echo get_the_permalink($next_post->ID); ?>">Next <i class="fa fa-chevron-right"></i></a>
			<?php
		}  ?>
	</ul>
</div><!-- posts-dir-nav -->
<?php
}



/*
	@Name: 		clear_content
	@Purpose: 	spit out a clear div to clear floats..
	@Params: 	none
	@Returns: 	void (html printed to screen.)
*/
function clear_content(){
	?>
	<div class='clearfix'></div><!-- clear everything -->
	<?php
}