<?php
/**
 * Class WPCF7R_Action_redirect_to_paypal file.
 *
 * @package cf7r
 */
if ( ! defined( 'ABSPATH' ) ) {
 	exit;
}

register_wpcf7r_actions(
    'redirect_to_paypal',
    __('Redirect to paypal' , 'wpcf7-redirect'),
    'WPCF7R_Action_redirect_to_paypal'
);

/**
 * class to handle paypal redirections
 * * @version  1.4.0
 */

class WPCF7R_Action_redirect_to_paypal extends WPCF7R_Action{

    public function __construct($post){
        parent::__construct($post);

        $this->api_base = new WPCF7R_Action_send_to_api($post);

        $this->paypal_live_url = "https://www.paypal.com/cgi-bin/webscr";
        $this->paypal_sandbox_url = "https://www.sandbox.paypal.com/cgi-bin/webscr";

        $this->line_items = 1;
    }

    /**
     * Get the fields relevant for this action
     * @return [type] [description]
     */
    public function get_action_fields(){
        return array_merge( array(
                'paypal_merchant_account' => array(
                    'name' => 'paypal_merchant_account',
                    'type' => 'text',
                    'label' => __( 'Your merchant account', 'wpcf7-redirect' ),
                    'placeholder' => __( '', 'wpcf7-redirect' ),
                    'value' => $this->get('paypal_merchant_account'),
                    'input_attr' => ' required ',
                    'class' => ''
                ),
                'merhcant_account_alert' => array(
                    'name' => 'general-alert',
                    'type' => 'notice',
                    'label' => __( 'Notice!', 'wpcf7-redirect' ),
                    'sub_title' => __( 'Please enter your Mechant account ID or Email address, Payments generated by this action will all be registered under this account, you can find your merchant account id using <a href="https://www.paypal.com/us/smarthelp/article/FAQ3850" target="_blank">this manual</a>', 'wpcf7-redirect' ),
                    'placeholder' => '',
                    'class' => 'field-notice-alert',
                    'show_selector' => ''
                ),
                'paypal_product' => array(
                    'name' => 'paypal_product',
                    'type' => 'section',
                    'title' => __( 'Product settings', 'wpcf7-redirect' ),
                    'class' => '',
                    'footer' => __( '<div class="qs-col qs-col-12">'.$this->get_formatted_mail_tags().'</div>', 'wpcf7-redirect' ),
                    'fields' => array(
                        'currency' => array(
                            'name' => 'currency',
                            'type' => 'select',
                            'label' => __( 'Currency', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Select a currency', 'wpcf7-redirect' ),
                            'value' => $this->get('currency') ? $this->get('currency') : 'USD',
                            'options' => $this->wpcf7r_get_paypal_currency_list(),
                            'class' => 'qs-col qs-col-6'
                        ),
                        'item_name' => array(
                            'name' => 'item_name',
                            'type' => 'text',
                            'label' => __( 'Product name', 'wpcf7-redirect' ),
                            'placeholder' => __( '', 'wpcf7-redirect' ),
                            'value' => $this->get('item_name'),
                            'input_attr' => ' required ',
                            'class' => 'qs-col qs-col-6'
                        ),
                        'item_number' => array(
                            'name' => 'item_number',
                            'type' => 'text',
                            'label' => __( 'Product SKU', 'wpcf7-redirect' ),
                            'placeholder' => __( '', 'wpcf7-redirect' ),
                            'input_attr' => ' required ',
                            'value' => $this->get('item_number'),
                            'class' => 'qs-col qs-col-6'
                        ),
                        'amount' => array(
                            'name' => 'amount',
                            'type' => 'text',
                            'label' => __( 'Product price', 'wpcf7-redirect' ),
                            'placeholder' => __( '', 'wpcf7-redirect' ),
                            'value' => $this->get('amount'),
                            'input_attr' => ' required ',
                            'class' => 'qs-col qs-col-6'
                        ),
                        'shipping' => array(
                            'name' => 'shipping',
                            'type' => 'text',
                            'label' => __( 'Shipping price', 'wpcf7-redirect' ),
                            'placeholder' => __( '', 'wpcf7-redirect' ),
                            'value' => $this->get('shipping'),
                            'class' => 'qs-col qs-col-6'
                        ),
                        'quantity' => array(
                            'name' => 'quantity',
                            'type' => 'text',
                            'label' => __( 'Item Quantity', 'wpcf7-redirect' ),
                            'placeholder' => __( '', 'wpcf7-redirect' ),
                            'input_attr' => ' required ',
                            'value' => $this->get('quantity'),
                            'class' => 'qs-col qs-col-6'
                        ),
                    )
                ),
                'user_details' => array(
                    'name' => 'user_details',
                    'type' => 'section',
                    'title' => __( 'User details (Optional)', 'wpcf7-redirect' ),
                    'footer' => __( '<div>'.$this->get_formatted_mail_tags().'</div>', 'wpcf7-redirect' ),
                    'class' => '',
                    'fields' => array(
                        'merhcant_account_alert' => array(
                            'name' => 'general-alert',
                            'type' => 'notice',
                            'label' => __( 'Notice!', 'wpcf7-redirect' ),
                            'sub_title' => __( 'All these fields are optional and documentd on <a href="https://www.paypalobjects.com/webstatic/en_IT/developer/docs/pdf/paypalpro.pdf" target="_blank">this manual</a>', 'wpcf7-redirect' ),
                            'placeholder' => '',
                            'class' => 'field-notice-alert',
                            'show_selector' => ''
                        ),
                        'first_name' => array(
                            'name' => 'first_name',
                            'type' => 'text',
                            'label' => __( 'First name', 'wpcf7-redirect' ),
                            'placeholder' => __( 'First name', 'wpcf7-redirect' ),
                            'value' => $this->get('first_name'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'last_name' => array(
                            'name' => 'last_name',
                            'type' => 'text',
                            'label' => __( 'Last name', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Last name', 'wpcf7-redirect' ),
                            'value' => $this->get('last_name'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'city' => array(
                            'name' => 'city',
                            'type' => 'text',
                            'label' => __( 'City', 'wpcf7-redirect' ),
                            'placeholder' => __( 'City', 'wpcf7-redirect' ),
                            'value' => $this->get('city'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'zip' => array(
                            'name' => 'zip',
                            'type' => 'text',
                            'label' => __( 'Zip code', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Zip code', 'wpcf7-redirect' ),
                            'value' => $this->get('zip'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'state' => array(
                            'name' => 'state',
                            'type' => 'text',
                            'label' => __( 'State', 'wpcf7-redirect' ),
                            'placeholder' => __( 'State', 'wpcf7-redirect' ),
                            'value' => $this->get('state'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'invoice' => array(
                            'name' => 'invoice',
                            'type' => 'text',
                            'label' => __( 'Invoice', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Invoice', 'wpcf7-redirect' ),
                            'value' => $this->get('invoice'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'country' => array(
                            'name' => 'country',
                            'type' => 'text',
                            'label' => __( 'Country', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Country', 'wpcf7-redirect' ),
                            'value' => $this->get('country'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'night_phone_b' => array(
                            'name' => 'night_phone_b',
                            'type' => 'text',
                            'label' => __( 'Phone number', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Phone number', 'wpcf7-redirect' ),
                            'value' => $this->get('night_phone_b'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'buyer_email' => array(
                            'name' => 'buyer_email',
                            'type' => 'text',
                            'label' => __( 'Buyer email', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Buyer email', 'wpcf7-redirect' ),
                            'value' => $this->get('buyer_email'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_address1' => array(
                            'name' => 'billing_address1',
                            'type' => 'text',
                            'label' => __( 'Street name of the billing address.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing Address 1', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_address1'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_address2' => array(
                            'name' => 'billing_address2',
                            'type' => 'text',
                            'label' => __( 'Street name of the billing address.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing Address 2', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_address2'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_city' => array(
                            'name' => 'billing_city',
                            'type' => 'text',
                            'label' => __( 'City name of the billing address.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing City', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_city'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_country' => array(
                            'name' => 'billing_country',
                            'type' => 'text',
                            'label' => __( 'City name of the billing address.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing Country', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_country'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_first_name' => array(
                            'name' => 'billing_first_name',
                            'type' => 'text',
                            'label' => __( 'First name of person the item is being billed to.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing First name', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_first_name'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_last_name' => array(
                            'name' => 'billing_last_name',
                            'type' => 'text',
                            'label' => __( 'Last name of person the item is being billed to.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing Last name', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_last_name'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_state' => array(
                            'name' => 'billing_state',
                            'type' => 'text',
                            'label' => __( 'State name of the billing address.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing State', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_state'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                        'billing_zip' => array(
                            'name' => 'billing_zip',
                            'type' => 'text',
                            'label' => __( 'Zip code of the billing address.', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Billing Zip', 'wpcf7-redirect' ),
                            'value' => $this->get('billing_zip'),
                            'class' =>  'qs-col qs-col-6 '
                        ),
                    )
                ),
                array(
                    'name' => 'paypal_advanced',
                    'type' => 'section',
                    'title' => __( 'Advanced  (Optional)', 'wpcf7-redirect' ),
                    'class' => '',
                    'fields' => array(
                        array(
                            'name' => 'return_url',
                            'type' => 'page_select',
                            'label' => __( 'Return url', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Return url', 'wpcf7-redirect' ),
                            'value' => $this->get('return_url'),
                            'class' => ''
                        ),
                        array(
                            'name' => 'cancel_url',
                            'type' => 'page_select',
                            'label' => __( 'Cancel url', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Cancel url', 'wpcf7-redirect' ),
                            'value' => $this->get('cancel_url'),
                            'class' => ''
                        ),
                        array(
                            'name' => 'return_method',
                            'type' => 'select',
                            'label' => __( 'Return method', 'wpcf7-redirect' ),
                            'placeholder' => __( 'Return method', 'wpcf7-redirect' ),
                            'value' => $this->get('return_method') ? $this->get('return_method') : '1',
                            'options' => array(
                                '1' => 'GET',
                                '2' => 'POST',
                            ),
                            'class' => ''
                        ),
                        array(
                            'name' => 'paypal_interface_language',
                            'type' => 'select',
                            'label' => __( 'Paypal interface language', 'wpcf7-redirect' ),
                            'value' => $this->get('paypal_interface_language') ? $this->get('paypal_interface_language') : 'us_EN',
                            'options' => $this->get_paypal_language_list(),
                            'class' => ''
                        ),
                        array(
                            'name' => 'paymentaction',
                            'type' => 'select',
                            'label' => __( 'Paypal payment action', 'wpcf7-redirect' ),
                            'sub_title' => __('Indicates whether the transaction is for payment on a final
                                        sale or an authorisation for a final sale (to be captured
                                        later). ', 'wpcf7-redirect' ),
                            'value' => $this->get('paymentaction') ? $this->get('paymentaction') : 'sale',
                            'options' => array(
                                'sale' => 'Sale',
                                'authorization' => 'Authorization',
                            ),
                            'class' => ''
                        ),
                        'open_new_window' => array(
                            'name' => 'open_new_window',
                            'type' => 'checkbox',
                            'label' => __( 'Open in new window', 'wpcf7-redirect' ),
                            'sub_title' => '',
                            'placeholder' => '',
                            'value' => $this->get('open_new_window')
                        ),
                        'use_sandbox_account' => array(
                            'name' => 'use_sandbox_account',
                            'type' => 'checkbox',
                            'label' => __( 'Use sandbox account', 'wpcf7-redirect' ),
                            'sub_title' => '',
                            'placeholder' => '',
                            'show_selector' => '.field-wrap-paypal_sandbox_account,.field-notice-alert',
                            'value' => $this->get('use_sandbox_account')
                        ),
                        'paypal_sandbox_account' => array(
                            'name' => 'paypal_sandbox_account',
                            'type' => 'text',
                            'label' => __( 'Your merchant sandbox account', 'wpcf7-redirect' ),
                            'placeholder' => __( '', 'wpcf7-redirect' ),
                            'value' => $this->get('paypal_sandbox_account'),
                            'class' =>  $this->get('use_sandbox_account') ? '' : 'field-hidden',
                        ),
                        'merhcant_sandbox_account_alert' => array(
                            'name' => 'general-alert',
                            'type' => 'notice',
                            'label' => __( 'Notice!', 'wpcf7-redirect' ),
                            'sub_title' => __( 'You can manage and create your paypal sandbox accounts using <a href="https://developer.paypal.com/docs/classic/lifecycle/sb_create-accounts/" target="_blank">this manual</a>', 'wpcf7-redirect' ),
                            'placeholder' => '',
                            'class' => $this->get('use_sandbox_account') ? 'field-notice-alert' : 'field-notice-alert field-hidden',
                            'show_selector' => ''
                        ),
                    )
                ),

            ),
            parent::get_default_fields()
        );
    }

    /**
     * Get settings page
     * @return [type] [description]
     */
    public function get_action_settings(){
        $this->get_settings_template('html-action-send-to-email.php');
    }
    /**
     * Handle a simple redirect rule
     * @param  [type] $rules    [description]
     * @param  [type] $response [description]
     * @return [type]           [description]
     */
    public function process( $submission ){
        //documented on https://www.paypalobjects.com/webstatic/en_IT/developer/docs/pdf/paypalpro.pdf

        $url = $this->get('use_sandbox_account') ? $this->paypal_sandbox_url : $this->paypal_live_url;
        $paypal_account = $this->get('use_sandbox_account') ? $this->get('paypal_sandbox_account') : $this->get('paypal_merchant_account');

        $paypal_parameters = array(
    		'business'			=> $paypal_account,
            'charset'			=> get_bloginfo('charset'),
            'cbt'				=> get_bloginfo('name'),
    		'currency_code'		=> $this->get('currency'),
    		'rm'				=> is_ssl() ? 2 : 1,
    		'lc'				=> $this->get('paypal_interface_language'),
            'upload'            => 1,
    		'amount'			=> $this->get('amount'),
            'return'			=> esc_url_raw($this->get_return_url()),
            'cancel_return'		=> esc_url_raw($this->get_cancel_url()),
            'notify_url'        => esc_url_raw($this->get_notify_url()),
            // 'image_url'         => '',
            'bn'				=> 'Query solutions ltd',
            'cmd'				=> '_cart',
            'custom'            => wp_json_encode(
				array(
					'order_id'  => $this->get_record_id()
				)
			),
    	);

        $args = array(
            'shipping'     => $this->replace_tags( $this->get('shipping') ),
            'item_name'    => $this->replace_tags( html_entity_decode( $this->get('item_name') , ENT_NOQUOTES, 'UTF-8' ) ),
            'quantity'     => $this->replace_tags( $this->get('quantity') ),
            'amount'       => $this->replace_tags( $this->get('amount') ),
            'item_number'  => $this->replace_tags( $this->get('item_number') ),
        );

        $line_items   = array();
        $line_items[] = $this->get_line_item($args);

        $user_fields  = $this->get_fields_settings('user_details');

        if( $line_items ){
            foreach( $line_items as $item_key => $item ){
                foreach( $item as $item_detail_key => $item_detail_value ){
                    $paypal_parameters[$item_detail_key] = $item_detail_value;
                }
            }
        }

        if( $user_fields ){
            foreach( $user_fields['fields'] as $user_field_key => $user_field ){
                if( $user_field['type'] != 'notice' ){
                    $paypal_parameters[$user_field_key] = wpcf7_mail_replace_tags( $this->get($user_field['name']) );
                }
            }
        }

        // print_r($paypal_parameters);
        // die();

        return array(
            'redirect_url' => add_query_arg( $paypal_parameters , $url ),
            'type' => $this->get('open_new_window') ? 'new_tab' : 'redirect'
        );
    }

    /**
     * Get line item for payapl
     * At the momenr only 1
     * @return [type] [description]
     */
    public function get_line_item($args){
        $line_item = array();

        $line_item[ 'item_name_' . $this->line_items ]   = $args['item_name'];
        $line_item[ 'quantity_' . $this->line_items ]    = $args['quantity'];
        $line_item[ 'amount_' . $this->line_items ]      = $args['amount'];
        $line_item[ 'item_number_' . $this->line_items ] = $args['item_number'];
        $line_item[ 'shipping_' . $this->line_items ]    = $args['shipping'];

        $this->line_items++;

        return $line_item;
    }
    /**
     * Get cancel url
     * @return [type] [description]
     */
    public function get_return_url(){
        return $this->get('return_url') ? get_permalink($this->get('return_url')) : home_url();
    }

    /**
     * [get_cancel_url description]
     * @return [type] [description]
     */
    public function get_cancel_url(){
        return $this->get('cancel_url') ? get_permalink($this->get('return_url')) : home_url();
    }
    /**
     * Get the payment record id
     * @return [type] [description]
     */
    public function get_record_id(){
        return isset( $this->record_id ) ? $this->record_id : '';
    }
    /**
     * [get_cancel_url description]
     * @return [type] [description]
     */
    public function get_notify_url(){
        $args = array(
            'action_id' => $this->get_id(),
            'action' => 'paypal_ipn',
            'record_id' => $this->get_record_id()
        );

        return add_query_arg( $args , home_url() );
    }
    /**
     * Get a list of supported paypal currencies
     * @return [type] [description]
     */
    function wpcf7r_get_paypal_currency_list(){
        return array (
                // 'ALL' => __('Albania Lek', 'wpcf7-redirect'),
                // 'AFN' => __('Afghanistan Afghani', 'wpcf7-redirect'),
                'ARS' => __('Argentina Peso (ARS)', 'wpcf7-redirect'),
                // 'AWG' => __('Aruba Guilder', 'wpcf7-redirect'),
                'AUD' => __('Australia Dollar (AUD)', 'wpcf7-redirect'),
                // 'AZN' => __('Azerbaijan New Manat', 'wpcf7-redirect'),
                // 'BSD' => __('Bahamas Dollar', 'wpcf7-redirect'),
                // 'BBD' => __('Barbados Dollar', 'wpcf7-redirect'),
                // 'BDT' => __('Bangladeshi taka', 'wpcf7-redirect'),
                // 'BYR' => __('Belarus Ruble', 'wpcf7-redirect'),
                // 'BZD' => __('Belize Dollar', 'wpcf7-redirect'),
                // 'BMD' => __('Bermuda Dollar', 'wpcf7-redirect'),
                // 'BOB' => __('Bolivia Boliviano', 'wpcf7-redirect'),
                // 'BAM' => __('Bosnia and Herzegovina Convertible Marka', 'wpcf7-redirect'),
                // 'BGN' => __('Bulgaria Lev', 'wpcf7-redirect'),
                // 'BWP' => __('Botswana Pula', 'wpcf7-redirect'),
                'BRL' => __('Brazil Real (BRL)', 'wpcf7-redirect'),
                // 'BND' => __('Brunei Darussalam Dollar', 'wpcf7-redirect'),
                // 'KHR' => __('Cambodia Riel', 'wpcf7-redirect'),
                'CAD' => __('Canada Dollar (CAD)', 'wpcf7-redirect'),
                // 'KYD' => __('Cayman Islands Dollar', 'wpcf7-redirect'),
                // 'CLP' => __('Chile Peso', 'wpcf7-redirect'),
                // 'CNY' => __('China Yuan Renminbi', 'wpcf7-redirect'),
                // 'COP' => __('Colombia Peso', 'wpcf7-redirect'),
                // 'CRC' => __('Costa Rica Colon', 'wpcf7-redirect'),
                // 'HRK' => __('Croatia Kuna', 'wpcf7-redirect'),
                // 'CUP' => __('Cuba Peso', 'wpcf7-redirect'),
                'CZK' => __('Czech Republic Koruna (CZK)', 'wpcf7-redirect'),
                'DKK' => __('Denmark Krone (DKK)', 'wpcf7-redirect'),
                // 'DOP' => __('Dominican Republic Peso', 'wpcf7-redirect'),
                // 'XCD' => __('East Caribbean Dollar', 'wpcf7-redirect'),
                // 'EGP' => __('Egypt Pound', 'wpcf7-redirect'),
                // 'SVC' => __('El Salvador Colon', 'wpcf7-redirect'),
                // 'EEK' => __('Estonia Kroon', 'wpcf7-redirect'),
                'EUR' => __('Euro Member Countries (EUR)', 'wpcf7-redirect'),
                // 'FKP' => __('Falkland Islands (Malvinas) Pound', 'wpcf7-redirect'),
                // 'FJD' => __('Fiji Dollar', 'wpcf7-redirect'),
                // 'GHC' => __('Ghana Cedis', 'wpcf7-redirect'),
                // 'GIP' => __('Gibraltar Pound', 'wpcf7-redirect'),
                // 'GTQ' => __('Guatemala Quetzal', 'wpcf7-redirect'),
                // 'GGP' => __('Guernsey Pound', 'wpcf7-redirect'),
                // 'GYD' => __('Guyana Dollar', 'wpcf7-redirect'),
                // 'HNL' => __('Honduras Lempira', 'wpcf7-redirect'),
                'HKD' => __('Hong Kong Dollar (HKD)', 'wpcf7-redirect'),
                'HUF' => __('Hungary Forint (HUF)', 'wpcf7-redirect'),
                // 'ISK' => __('Iceland Krona', 'wpcf7-redirect'),
                'INR' => __('India Rupee (INR)', 'wpcf7-redirect'),
                // 'IDR' => __('Indonesia Rupiah', 'wpcf7-redirect'),
                // 'IRR' => __('Iran Rial', 'wpcf7-redirect'),
                // 'IMP' => __('Isle of Man Pound', 'wpcf7-redirect'),
                'ILS' => __('Israel Shekel (ILS)', 'wpcf7-redirect'),
                // 'JMD' => __('Jamaica Dollar', 'wpcf7-redirect'),
                'JPY' => __('Japan Yen (JPY)', 'wpcf7-redirect'),
                // 'JEP' => __('Jersey Pound', 'wpcf7-redirect'),
                // 'KZT' => __('Kazakhstan Tenge', 'wpcf7-redirect'),
                // 'KPW' => __('Korea (North) Won', 'wpcf7-redirect'),
                // 'KRW' => __('Korea (South) Won', 'wpcf7-redirect'),
                // 'KGS' => __('Kyrgyzstan Som', 'wpcf7-redirect'),
                // 'LAK' => __('Laos Kip', 'wpcf7-redirect'),
                // 'LVL' => __('Latvia Lat', 'wpcf7-redirect'),
                // 'LBP' => __('Lebanon Pound', 'wpcf7-redirect'),
                // 'LRD' => __('Liberia Dollar', 'wpcf7-redirect'),
                // 'LTL' => __('Lithuania Litas', 'wpcf7-redirect'),
                // 'MKD' => __('Macedonia Denar', 'wpcf7-redirect'),
                'MYR' => __('Malaysia Ringgit (MYR)', 'wpcf7-redirect'),
                // 'MUR' => __('Mauritius Rupee', 'wpcf7-redirect'),
                'MXN' => __('Mexico Peso (MXN)', 'wpcf7-redirect'),
                // 'MNT' => __('Mongolia Tughrik', 'wpcf7-redirect'),
                // 'MZN' => __('Mozambique Metical', 'wpcf7-redirect'),
                // 'NAD' => __('Namibia Dollar', 'wpcf7-redirect'),
                // 'NPR' => __('Nepal Rupee', 'wpcf7-redirect'),
                // 'ANG' => __('Netherlands Antilles Guilder', 'wpcf7-redirect'),
                'NZD' => __('New Zealand Dollar (NZD)', 'wpcf7-redirect'),
                // 'NIO' => __('Nicaragua Cordoba', 'wpcf7-redirect'),
                // 'NGN' => __('Nigeria Naira', 'wpcf7-redirect'),
                'NOK' => __('Norway Krone (NOK)', 'wpcf7-redirect'),
                // 'OMR' => __('Oman Rial', 'wpcf7-redirect'),
                // 'PKR' => __('Pakistan Rupee', 'wpcf7-redirect'),
                // 'PAB' => __('Panama Balboa', 'wpcf7-redirect'),
                // 'PYG' => __('Paraguay Guarani', 'wpcf7-redirect'),
                // 'PEN' => __('Peru Nuevo Sol', 'wpcf7-redirect'),
                'PHP' => __('Philippines Peso (PHP)', 'wpcf7-redirect'),
                'PLN' => __('Poland Zloty (PLN)', 'wpcf7-redirect'),
                // 'QAR' => __('Qatar Riyal', 'wpcf7-redirect'),
                // 'RON' => __('Romania New Leu', 'wpcf7-redirect'),
                'RUB' => __('Russia Ruble (RUB)', 'wpcf7-redirect'),
                // 'SHP' => __('Saint Helena Pound', 'wpcf7-redirect'),
                // 'SAR' => __('Saudi Arabia Riyal', 'wpcf7-redirect'),
                // 'RSD' => __('Serbia Dinar', 'wpcf7-redirect'),
                // 'SCR' => __('Seychelles Rupee', 'wpcf7-redirect'),
                'SGD' => __('Singapore Dollar (SGD)', 'wpcf7-redirect'),
                // 'SBD' => __('Solomon Islands Dollar', 'wpcf7-redirect'),
                // 'SOS' => __('Somalia Shilling', 'wpcf7-redirect'),
                // 'ZAR' => __('South Africa Rand', 'wpcf7-redirect'),
                // 'LKR' => __('Sri Lanka Rupee', 'wpcf7-redirect'),
                'SEK' => __('Sweden Krona (SEK)', 'wpcf7-redirect'),
                'CHF' => __('Switzerland Franc (CHF)', 'wpcf7-redirect'),
                // 'SRD' => __('Suriname Dollar', 'wpcf7-redirect'),
                // 'SYP' => __('Syria Pound', 'wpcf7-redirect'),
                'TWD' => __('Taiwan New Dollar (TWD)', 'wpcf7-redirect'),
                'THB' => __('Thailand Baht (THB)', 'wpcf7-redirect'),
                // 'TTD' => __('Trinidad and Tobago Dollar', 'wpcf7-redirect'),
                // 'TRY' => __('Turkey Lira', 'wpcf7-redirect'),
                // 'TRL' => __('Turkey Lira', 'wpcf7-redirect'),
                // 'TVD' => __('Tuvalu Dollar', 'wpcf7-redirect'),
                // 'UAH' => __('Ukraine Hryvna', 'wpcf7-redirect'),
                'GBP' => __('United Kingdom Pound (GBP)', 'wpcf7-redirect'),
                'USD' => __('United States Dollar (USD)', 'wpcf7-redirect'),
                // 'UYU' => __('Uruguay Peso', 'wpcf7-redirect'),
                // 'UZS' => __('Uzbekistan Som', 'wpcf7-redirect'),
                // 'VEF' => __('Venezuela Bolivar', 'wpcf7-redirect'),
                // 'VND' => __('Viet Nam Dong', 'wpcf7-redirect'),
                // 'YER' => __('Yemen Rial', 'wpcf7-redirect'),
                // 'ZWD' => __('Zimbabwe Dollar'),
            );
    }

    /**
     * Get an array of supported interface lanauge
     * @return [type] [description]
     */
    function get_paypal_language_list(){
        $languages = array(
            "en_US" => __('US English' , 'wpcf7-redirect'),
            "da_DK" => __('Danish' , 'wpcf7-redirect'),
            "de_DE" => __('German' , 'wpcf7-redirect'),
            "en_GB" => __('UK English' , 'wpcf7-redirect'),
            "es_ES" => __('Spanish' , 'wpcf7-redirect'),
            "fr_CA" => __('French' , 'wpcf7-redirect'),
            "he_IL" => __('Hebrew' , 'wpcf7-redirect'),
            "id_ID" => __('Indonesian' , 'wpcf7-redirect'),
            "it_IT" => __('Italian' , 'wpcf7-redirect'),
            "ja_JP" => __('Japanese' , 'wpcf7-redirect'),
            "nl_BE" => __('Dutch' , 'wpcf7-redirect'),
            "no_NO" => __('Norwgian' , 'wpcf7-redirect'),
            "pl_PL" => __('Polish' , 'wpcf7-redirect'),
            "pt_BR" => __('Portuguese' , 'wpcf7-redirect'),
            "ru_RU" => __('Russian' , 'wpcf7-redirect'),
            "sv_SE" => __('Swedish' , 'wpcf7-redirect'),
            "tr_TR" => __('Turkish' , 'wpcf7-redirect'),
            "th_TH" => __('Thai' , 'wpcf7-redirect'),
            "zh_CN" => __('Chinese (Simplified)' , 'wpcf7-redirect'),
            "zh_HK" => __('Chinese (Traditional)' , 'wpcf7-redirect'),
            "zh_TW" => __('Chinese (Taiwan)' , 'wpcf7-redirect'),
        );
        return $languages;
    }
}
